<?php
/* @var $this NewsletterSubscriptionAdmin */
/* @var $controls NewsletterSubscriptionAdmin */

defined('ABSPATH') || exit;

if (!$controls->is_action()) {
    $controls->data = $this->get_main_options('htmlforms');
}

if ($controls->is_action('save')) {
    $this->save_main_options($controls->data, 'htmlforms');
    $controls->add_toast_saved();
}
?>

<div class="wrap" id="tnp-wrap">

    <?php include NEWSLETTER_ADMIN_HEADER; ?>

    <div id="tnp-heading">

        <?php $controls->title_help('/subscription/newsletter-forms/') ?>
<!--        <h2><?php esc_html_e('Forms', 'newsletter') ?></h2>-->
        <?php include __DIR__ . '/nav-forms.php' ?>

    </div>

    <div id="tnp-body">
        <p>
            <strong>Old feature</strong>. To inject an HTML form use the shortcode <code>[newsletter_form form="X"]</code> where
            <code>X</code> is the form number.
        </p>

        <?php $controls->show(); ?>

        <form method="post" action="">
            <?php $controls->init(); ?>

            <div id="tabs">

                <ul>
                    <li><a href="#tabs-forms">Forms</a></li>
                    <li><a href="#tabs-html">HTML sample</a></li>
                </ul>

                <div id="tabs-forms">
                    <table class="form-table">
                        <?php for ($i = 1; $i <= 10; $i++) { ?>
                            <tr>
                                <th>Form <?php echo $i; ?></th>
                                <td>
                                    <?php $controls->textarea('form_' . $i); ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>

                <div id="tabs-html">

                    <p>This panel shows the form HTML code generated by Newsletter if you want to copy it as starting point for a custom form.</p>

                    <h3>Standard form code</h3>
                    <textarea readonly style="width: 100%; height: 500px; font-family: monospace"><?php echo esc_html(NewsletterSubscription::instance()->get_subscription_form()); ?></textarea>

                    <h3>Widget form code</h3>
                    <textarea readonly style="width: 100%; height: 500px; font-family: monospace"><?php echo esc_html(NewsletterSubscription::instance()->get_subscription_form()); ?></textarea>

                </div>

            </div>

            <p><?php $controls->button_save(); ?></p>
        </form>

    </div>

    <?php include NEWSLETTER_ADMIN_FOOTER; ?>

</div>
